/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2016-2023 Intel Corporation <www.intel.com>
 */

#ifndef _SOCFPGA_SOC64_BASE_HARDWARE_H_
#define _SOCFPGA_SOC64_BASE_HARDWARE_H_

#if IS_ENABLED(CONFIG_ARCH_SOCFPGA_AGILEX5)
#define SOCFPGA_CCU_ADDRESS			0x1c000000
#define SOCFPGA_CCU_DII2_GIC_BAR_REG		0x420
#define SOCFPGA_CCU_DII2_GIC_LR_REG		0x424
#define SOCFPGA_CCU_DII2_GIC_HR_REG		0x428

#define SOCFPGA_FPGA2SOC_ADDRESS		0x1c001000
#define SOCFPGA_FPGA2SOC_PSS_BAR_REG		0x400
#define SOCFPGA_FPGA2SOC_PSS_LR_REG		0x404
#define SOCFPGA_FPGA2SOC_PSS_HR_REG		0x408

#define SOCFPGA_GIC_M_ADDRESS			0x1c002000
#define SOCFPGA_TCU_ADDRESS			0x1c003000
#define SOCFPGA_CCU_IOM_ADDRESS			0x1c004000
#define SOCFPGA_DCE0_ADDRESS			0x1c005000
#define SOCFPGA_DCE1_ADDRESS			0x1c006000

#define SOCFPGA_SECREG_NCAIU1AMIGR_REG			0x3c0
#define SOCFPGA_SECREG_NCAIU1MIFSR_REG			0x3c4
#define SOCFPGA_SECREG_DII1_MPFE_BAR_REG		0x410
#define SOCFPGA_SECREG_DII1_MPFE_LR_REG			0x414
#define SOCFPGA_SECREG_DII1_MPFE_HR_REG			0x418
#define SOCFPGA_SECREG_NCAIU0_LWSOC2FPGA_BAR_REG	0x440
#define SOCFPGA_SECREG_NCAIU0_LWSOC2FPGA_LR_REG		0x444
#define SOCFPGA_SECREG_NCAIU0_LWSOC2FPGA_HR_REG		0x448
#define SOCFPGA_SECREG_NCAIU0_SOC2FPGA_1G_BAR_REG	0x450
#define SOCFPGA_SECREG_NCAIU0_SOC2FPGA_1G_LR_REG	0x454
#define SOCFPGA_SECREG_NCAIU0_SOC2FPGA_1G_HR_REG	0x458
#define SOCFPGA_SECREG_DMI_SDRAM_2G_BAR_REG		0x460
#define SOCFPGA_SECREG_DMI_SDRAM_2G_LR_REG		0x464
#define SOCFPGA_SECREG_DMI_SDRAM_2G_HR_REG		0x468
#define SOCFPGA_SECREG_NCAIU0_SOC2FPGA_16G_BAR_REG	0x470
#define SOCFPGA_SECREG_NCAIU0_SOC2FPGA_16G_LR_REG	0x474
#define SOCFPGA_SECREG_NCAIU0_SOC2FPGA_16G_HR_REG	0x478
#define SOCFPGA_SECREG_DMI_SDRAM_30G_BAR_REG		0x480
#define SOCFPGA_SECREG_DMI_SDRAM_30G_LR_REG		0x484
#define SOCFPGA_SECREG_DMI_SDRAM_30G_HR_REG		0x488
#define SOCFPGA_SECREG_NCAIU0_SOC2FPGA_256G_BAR_REG	0x490
#define SOCFPGA_SECREG_NCAIU0_SOC2FPGA_256G_LR_REG	0x494
#define SOCFPGA_SECREG_NCAIU0_SOC2FPGA_256G_HR_REG	0x498
#define SOCFPGA_SECREG_DMI_SDRAM_480G_BAR_REG		0x4a0
#define SOCFPGA_SECREG_DMI_SDRAM_480G_LR_REG		0x4a4
#define SOCFPGA_SECREG_DMI_SDRAM_480G_HR_REG		0x4a8

#define SOCFPGA_DMI0_ADDRESS			0x1c007000
#define SOCFPGA_DMI0_DMIUSMCTCR_REG		0x300

#define SOCFPGA_DMI1_ADDRESS			0x1c008000
#define SOCFPGA_DMI1_DMIUSMCTCR_REG		0x300

#define SOCFPGA_F2SDRAM_MGR_ADDRESS		0x18001000
#define SOCFPGA_SMMU_ADDRESS			0x16000000
#define SOCFPGA_OCRAM_FIREWALL_ADDRESS		0x108cc400
#define SOCFPGA_MAILBOX_ADDRESS			0x10a30000
#define SOCFPGA_UART0_ADDRESS			0x10c02000
#define SOCFPGA_UART1_ADDRESS			0x10c02100
#define SOCFPGA_SPTIMER0_ADDRESS		0x10c03000
#define SOCFPGA_SPTIMER1_ADDRESS		0x10c03100
#define SOCFPGA_SYSTIMER0_ADDRESS		0x10d00000
#define SOCFPGA_SYSTIMER1_ADDRESS		0x10d00100
#define SOCFPGA_L4WD0_ADDRESS			0x10d00200
#define SOCFPGA_L4WD1_ADDRESS			0x10d00300
#define SOCFPGA_L4WD2_ADDRESS			0x10d00400
#define SOCFPGA_L4WD3_ADDRESS			0x10d00500
#define SOCFPGA_L4WD4_ADDRESS			0x10d00600
#define SOCFPGA_GTIMER_SEC_ADDRESS		0x10d01000
#define SOCFPGA_GTIMER_NSEC_ADDRESS		0x10d02000
#define SOCFPGA_CLKMGR_ADDRESS			0x10d10000
#define SOCFPGA_RSTMGR_ADDRESS			0x10d11000
#define SOCFPGA_SYSMGR_ADDRESS			0x10d12000
#define SOCFPGA_PINMUX_ADDRESS			0x10d13000
#define SOCFPGA_OCRAM_ADDRESS			0x00000000
#define SOCFPGA_MPFE_CSR_ADDRESS		0x18000000
#define SOCFPGA_FW_DDR_CCU_DMI0_ADDRESS		0x18000800
#define SOCFPGA_FW_DDR_CCU_DMI1_ADDRESS		0x18000A00
#define SOCFPGA_FW_TBU2NOC_ADDRESS		0x18000C00
#define SOCFPGA_FIREWALL_L4_PER_ADDRESS		0x10d21000
#define SOCFPGA_FIREWALL_L4_PER_NAND_REG	0x0
#define SOCFPGA_FIREWALL_L4_PER_USB0_REG	0xc
#define SOCFPGA_FIREWALL_L4_PER_USB1_REG	0x10
#define SOCFPGA_FIREWALL_L4_PER_SPI_MAIN0_REG	0x1c
#define SOCFPGA_FIREWALL_L4_PER_SPI_MAIN1_REG	0x20
#define SOCFPGA_FIREWALL_L4_PER_SPI_SEC0_REG	0x24
#define SOCFPGA_FIREWALL_L4_PER_SPI_SEC1_REG	0x28
#define SOCFPGA_FIREWALL_L4_PER_EMAC0_REG	0x2c
#define SOCFPGA_FIREWALL_L4_PER_EMAC1_REG	0x30
#define SOCFPGA_FIREWALL_L4_PER_EMAC2_REG	0x34
#define SOCFPGA_FIREWALL_L4_PER_SDMMC_REG	0x40
#define SOCFPGA_FIREWALL_L4_PER_GPIO0_REG	0x44
#define SOCFPGA_FIREWALL_L4_PER_GPIO1_REG	0x48
#define SOCFPGA_FIREWALL_L4_PER_I2C0_REG	0x50
#define SOCFPGA_FIREWALL_L4_PER_I2C1_REG	0x54
#define SOCFPGA_FIREWALL_L4_PER_I2C2_REG	0x58
#define SOCFPGA_FIREWALL_L4_PER_I2C3_REG	0x5c
#define SOCFPGA_FIREWALL_L4_PER_I2C4_REG	0x60
#define SOCFPGA_FIREWALL_L4_PER_SP_TIMER0_REG	0x64
#define SOCFPGA_FIREWALL_L4_PER_SP_TIMER1_REG	0x68
#define SOCFPGA_FIREWALL_L4_PER_UART0_REG	0x6c
#define SOCFPGA_FIREWALL_L4_PER_UART1_REG	0x70
#define SOCFPGA_FIREWALL_L4_PER_I3C0_REG	0x74
#define SOCFPGA_FIREWALL_L4_PER_I3C1_REG	0x78
#define SOCFPGA_FIREWALL_L4_PER_DMA0_REG	0x7c
#define SOCFPGA_FIREWALL_L4_PER_DMA1_REG	0x80
#define SOCFPGA_FIREWALL_L4_PER_COMBO_PHY_REG	0x84
#define SOCFPGA_FIREWALL_L4_PER_NAND_SDMA_REG	0x88

#define SOCFPGA_FIREWALL_L4_SYS_ADDRESS			0x10d21100
#define SOCFPGA_FIREWALL_L4_SYS_DMA_ECC_REG		0x08
#define SOCFPGA_FIREWALL_L4_SYS_EMAC0RX_ECC_REG		0x0c
#define SOCFPGA_FIREWALL_L4_SYS_EMAC0TX_ECC_REG		0x10
#define SOCFPGA_FIREWALL_L4_SYS_EMAC1RX_ECC_REG		0x14
#define SOCFPGA_FIREWALL_L4_SYS_EMAC1TX_ECC_REG		0x18
#define SOCFPGA_FIREWALL_L4_SYS_EMAC2RX_ECC_REG		0x1c
#define SOCFPGA_FIREWALL_L4_SYS_EMAC2TX_ECC_REG		0x20
#define SOCFPGA_FIREWALL_L4_SYS_NAND_ECC_REG		0x2c
#define SOCFPGA_FIREWALL_L4_SYS_NAND_READ_ECC_REG	0x30
#define SOCFPGA_FIREWALL_L4_SYS_NAND_WRITE_ECC_REG	0x34
#define SOCFPGA_FIREWALL_L4_SYS_OCRAM_ECC_REG		0x38
#define SOCFPGA_FIREWALL_L4_SYS_SDMMC_ECC_REG		0x40
#define SOCFPGA_FIREWALL_L4_SYS_USB0_ECC_REG		0x44
#define SOCFPGA_FIREWALL_L4_SYS_USB1_CACHEECC_REG	0x48
#define SOCFPGA_FIREWALL_L4_SYS_CLOCK_MANAGER_REG	0x4c
#define SOCFPGA_FIREWALL_L4_SYS_IO_MANAGER_REG		0x54
#define SOCFPGA_FIREWALL_L4_SYS_RESET_MANAGER_REG	0x58
#define SOCFPGA_FIREWALL_L4_SYS_SYSTEM_MANAGER_REG	0x5c
#define SOCFPGA_FIREWALL_L4_SYS_OSC0_TIMER_REG		0x60
#define SOCFPGA_FIREWALL_L4_SYS_OSC1_TIMER0_REG		0x64
#define SOCFPGA_FIREWALL_L4_SYS_WATCHDOG0_REG		0x68
#define SOCFPGA_FIREWALL_L4_SYS_WATCHDOG1_REG		0x6c
#define SOCFPGA_FIREWALL_L4_SYS_WATCHDOG2_REG		0x70
#define SOCFPGA_FIREWALL_L4_SYS_WATCHDOG3_REG		0x74
#define SOCFPGA_FIREWALL_L4_SYS_DAP_REG			0x78
#define SOCFPGA_FIREWALL_L4_SYS_WATCHDOG4_REG		0x7c
#define SOCFPGA_FIREWALL_L4_SYS_POWER_MANAGER_REG	0x80
#define SOCFPGA_FIREWALL_L4_SYS_USB1_RXECC_REG		0x84
#define SOCFPGA_FIREWALL_L4_SYS_USB1_TXECC_REG		0x88
#define SOCFPGA_FIREWALL_L4_SYS_L4_NOC_PROBES_REG	0x90
#define SOCFPGA_FIREWALL_L4_SYS_L4_NOC_QOS_REG		0x94

#define SOCFPGA_FIREWALL_SOC2FPGA_ADDRESS	0x10d21200
#define SOCFPGA_FIREWALL_LWSOC2FPGA_ADDRESS	0x10d21300
#define SOCFPGA_FIREWALL_TCU_ADDRESS		0x10d21400
#define GICD_BASE				0x1d000000
#define GICR_BASE				0x1d060000

#define SOCFPGA_AGILEX5_DDR_BASE		0x80000000

#else
#define SOCFPGA_CCU_ADDRESS			0xf7000000
#define SOCFPGA_SDR_SCHEDULER_ADDRESS		0xf8000400
#define SOCFPGA_HMC_MMR_IO48_ADDRESS		0xf8010000
#define SOCFPGA_SDR_ADDRESS			0xf8011000
#define SOCFPGA_FW_MPFE_SCR_ADDRESS		0xf8020000
#define SOCFPGA_FW_MPU_DDR_SCR_ADDRESS		0xf8020100
#define SOCFPGA_F2SDRAM_MGR_ADDRESS		0xf8024000
#define SOCFPGA_SMMU_ADDRESS			0xfa000000
#define SOCFPGA_MAILBOX_ADDRESS			0xffa30000
#define SOCFPGA_UART0_ADDRESS			0xffc02000
#define SOCFPGA_UART1_ADDRESS			0xffc02100
#define SOCFPGA_SPTIMER0_ADDRESS		0xffc03000
#define SOCFPGA_SPTIMER1_ADDRESS		0xffc03100
#define SOCFPGA_SYSTIMER0_ADDRESS		0xffd00000
#define SOCFPGA_SYSTIMER1_ADDRESS		0xffd00100
#define SOCFPGA_L4WD0_ADDRESS			0xffd00200
#define SOCFPGA_L4WD1_ADDRESS			0xffd00300
#define SOCFPGA_L4WD2_ADDRESS			0xffd00400
#define SOCFPGA_L4WD3_ADDRESS			0xffd00500
#define SOCFPGA_GTIMER_SEC_ADDRESS		0xffd01000
#define SOCFPGA_GTIMER_NSEC_ADDRESS		0xffd02000
#define SOCFPGA_CLKMGR_ADDRESS			0xffd10000
#define SOCFPGA_RSTMGR_ADDRESS			0xffd11000
#define SOCFPGA_SYSMGR_ADDRESS			0xffd12000
#define SOCFPGA_PINMUX_DEDICATED_IO_ADDRESS	0xffd13000
#define SOCFPGA_FIREWALL_L4_PER			0xffd21000
#define SOCFPGA_FIREWALL_L4_SYS			0xffd21100
#define SOCFPGA_FIREWALL_SOC2FPGA		0xffd21200
#define SOCFPGA_FIREWALL_LWSOC2FPGA		0xffd21300
#define SOCFPGA_FIREWALL_TCU			0xffd21400
#define SOCFPGA_FIREWALL_PRIV_MEMORYMAP_PRIV	0xffd24800
#define SOCFPGA_DMANONSECURE_ADDRESS		0xffda0000
#define SOCFPGA_DMASECURE_ADDRESS		0xffda1000
#define SOCFPGA_OCRAM_ADDRESS			0xffe00000
#define GICD_BASE				0xfffc1000
#define GICC_BASE				0xfffc2000
#endif

#endif /* _SOCFPGA_SOC64_BASE_HARDWARE_H_ */
