/*
 * Copyright (C) 2014 Altera Corporation <www.altera.com>
 *
 * SPDX-License-Identifier:	GPL-2.0
 */

#include <mach/socfpga/arria10-system-manager.h>

#ifndef	_ARRIA10_SDRAM_H_
#define	_ARRIA10_SDRAM_H_

#define ARRIA10_ECC_HMC_OCP_IP_REV_ID			(ARRIA10_SDR_ADDR + 0x00)
#define ARRIA10_ECC_HMC_OCP_DDRIOCTRL			(ARRIA10_SDR_ADDR + 0x08)
#define ARRIA10_ECC_HMC_OCP_DDRCALSTAT			(ARRIA10_SDR_ADDR + 0x0c)
#define ARRIA10_ECC_HMC_OCP_MPR_OBEAT1			(ARRIA10_SDR_ADDR + 0x10)
#define ARRIA10_ECC_HMC_OCP_MPR_1BEAT1			(ARRIA10_SDR_ADDR + 0x14)
#define ARRIA10_ECC_HMC_OCP_MPR_2BEAT1			(ARRIA10_SDR_ADDR + 0x18)
#define ARRIA10_ECC_HMC_OCP_MPR_3BEAT1			(ARRIA10_SDR_ADDR + 0x1c)
#define ARRIA10_ECC_HMC_OCP_MPR_4BEAT1			(ARRIA10_SDR_ADDR + 0x20)
#define ARRIA10_ECC_HMC_OCP_MPR_5BEAT1			(ARRIA10_SDR_ADDR + 0x24)
#define ARRIA10_ECC_HMC_OCP_MPR_6BEAT1			(ARRIA10_SDR_ADDR + 0x28)
#define ARRIA10_ECC_HMC_OCP_MPR_7BEAT1			(ARRIA10_SDR_ADDR + 0x2c)
#define ARRIA10_ECC_HMC_OCP_MPR_8BEAT1			(ARRIA10_SDR_ADDR + 0x30)
#define ARRIA10_ECC_HMC_OCP_MPR_OBEAT2			(ARRIA10_SDR_ADDR + 0x34)
#define ARRIA10_ECC_HMC_OCP_MPR_1BEAT2			(ARRIA10_SDR_ADDR + 0x38)
#define ARRIA10_ECC_HMC_OCP_MPR_2BEAT2			(ARRIA10_SDR_ADDR + 0x3c)
#define ARRIA10_ECC_HMC_OCP_MPR_3BEAT2			(ARRIA10_SDR_ADDR + 0x40)
#define ARRIA10_ECC_HMC_OCP_MPR_4BEAT2			(ARRIA10_SDR_ADDR + 0x44)
#define ARRIA10_ECC_HMC_OCP_MPR_5BEAT2			(ARRIA10_SDR_ADDR + 0x48)
#define ARRIA10_ECC_HMC_OCP_MPR_6BEAT2			(ARRIA10_SDR_ADDR + 0x4c)
#define ARRIA10_ECC_HMC_OCP_MPR_7BEAT2			(ARRIA10_SDR_ADDR + 0x50)
#define ARRIA10_ECC_HMC_OCP_MPR_8BEAT2			(ARRIA10_SDR_ADDR + 0x54)
#define ARRIA10_ECC_HMC_OCP_MPR_AUTO_PRECHARGE		(ARRIA10_SDR_ADDR + 0x60)
#define ARRIA10_ECC_HMC_OCP_MPR_ECCCTRL1		(ARRIA10_SDR_ADDR + 0x100)
#define ARRIA10_ECC_HMC_OCP_MPR_ECCCTRL2		(ARRIA10_SDR_ADDR + 0x104)
#define ARRIA10_ECC_HMC_OCP_MPR_ERRINTEN		(ARRIA10_SDR_ADDR + 0x110)
#define ARRIA10_ECC_HMC_OCP_MPR_ERRINTENS		(ARRIA10_SDR_ADDR + 0x114)
#define ARRIA10_ECC_HMC_OCP_MPR_ERRINTENR		(ARRIA10_SDR_ADDR + 0x118)
#define ARRIA10_ECC_HMC_OCP_MPR_INTMODE			(ARRIA10_SDR_ADDR + 0x11c)
#define ARRIA10_ECC_HMC_OCP_MPR_INTSTAT			(ARRIA10_SDR_ADDR + 0x120)
#define ARRIA10_ECC_HMC_OCP_MPR_DIAGINTTEST		(ARRIA10_SDR_ADDR + 0x124)
#define ARRIA10_ECC_HMC_OCP_MPR_MODSTAT			(ARRIA10_SDR_ADDR + 0x128)
#define ARRIA10_ECC_HMC_OCP_MPR_DERRADDRA		(ARRIA10_SDR_ADDR + 0x12c)
#define ARRIA10_ECC_HMC_OCP_MPR_SERRADDRA		(ARRIA10_SDR_ADDR + 0x130)
#define ARRIA10_ECC_HMC_OCP_MPR_AUTOWB_CORRADDR		(ARRIA10_SDR_ADDR + 0x138)
#define ARRIA10_ECC_HMC_OCP_MPR_SERRCNTREG		(ARRIA10_SDR_ADDR + 0x13c)
#define ARRIA10_ECC_HMC_OCP_MPR_AUTOWB_DROP_CNTREG	(ARRIA10_SDR_ADDR + 0x140)
#define ARRIA10_ECC_HMC_OCP_MPR_ECC_REG2WRECCDATABUS	(ARRIA10_SDR_ADDR + 0x144)
#define ARRIA10_ECC_HMC_OCP_MPR_ECC_RDECCDATA2REGBUS	(ARRIA10_SDR_ADDR + 0x148)
#define ARRIA10_ECC_HMC_OCP_MPR_ECC_REG2RDECCDATABUS	(ARRIA10_SDR_ADDR + 0x14c)
#define ARRIA10_ECC_HMC_OCP_MPR_ECC_DIAGON		(ARRIA10_SDR_ADDR + 0x150)
#define ARRIA10_ECC_HMC_OCP_MPR_ECC_DECSTAT		(ARRIA10_SDR_ADDR + 0x154)
#define ARRIA10_ECC_HMC_OCP_MPR_ECC_ERRGENADDR_0	(ARRIA10_SDR_ADDR + 0x160)
#define ARRIA10_ECC_HMC_OCP_MPR_ECC_ERRGENADDR_1	(ARRIA10_SDR_ADDR + 0x164)
#define ARRIA10_ECC_HMC_OCP_MPR_ECC_ERRGENADDR_2	(ARRIA10_SDR_ADDR + 0x168)
#define ARRIA10_ECC_HMC_OCP_MPR_ECC_ERRGENADDR_3	(ARRIA10_SDR_ADDR + 0x16c)
#define ARRIA10_ECC_HMC_OCP_MPR_ECC_REG2RDDATABUS_BEAT0	(ARRIA10_SDR_ADDR + 0x170)
#define ARRIA10_ECC_HMC_OCP_MPR_ECC_REG2RDDATABUS_BEAT1	(ARRIA10_SDR_ADDR + 0x174)
#define ARRIA10_ECC_HMC_OCP_MPR_ECC_REG2RDDATABUS_BEAT2	(ARRIA10_SDR_ADDR + 0x178)
#define ARRIA10_ECC_HMC_OCP_MPR_ECC_REG2RDDATABUS_BEAT3	(ARRIA10_SDR_ADDR + 0x17c)

#define ARRIA10_NOC_DDR_T_MAIN_SCHEDULER_ID_COREID		(ARRIA10_SDR_SCHEDULER_ADDR + 0x00)
#define ARRIA10_NOC_DDR_T_MAIN_SCHEDULER_ID_REVISIONID		(ARRIA10_SDR_SCHEDULER_ADDR + 0x04)
#define ARRIA10_NOC_DDR_T_MAIN_SCHEDULER_DDRCONF		(ARRIA10_SDR_SCHEDULER_ADDR + 0x08)
#define ARRIA10_NOC_DDR_T_MAIN_SCHEDULER_DDRTIMING		(ARRIA10_SDR_SCHEDULER_ADDR + 0x0c)
#define ARRIA10_NOC_DDR_T_MAIN_SCHEDULER_DDRMODE		(ARRIA10_SDR_SCHEDULER_ADDR + 0x10)
#define ARRIA10_NOC_DDR_T_MAIN_SCHEDULER_READLATENCY		(ARRIA10_SDR_SCHEDULER_ADDR + 0x14)
#define ARRIA10_NOC_DDR_T_MAIN_SCHEDULER_ACTIVATE		(ARRIA10_SDR_SCHEDULER_ADDR + 0x38)
#define ARRIA10_NOC_DDR_T_MAIN_SCHEDULER_DEVTODEV		(ARRIA10_SDR_SCHEDULER_ADDR + 0x3c)

#define ARRIA10_IO48_HMC_MMR_DBGCFG0		(ARRIA10_HMC_MMR_IO48_ADDR + 0x00)
#define ARRIA10_IO48_HMC_MMR_DBGCFG1		(ARRIA10_HMC_MMR_IO48_ADDR + 0x04)
#define ARRIA10_IO48_HMC_MMR_DBGCFG2		(ARRIA10_HMC_MMR_IO48_ADDR + 0x08)
#define ARRIA10_IO48_HMC_MMR_DBGCFG3		(ARRIA10_HMC_MMR_IO48_ADDR + 0x0c)
#define ARRIA10_IO48_HMC_MMR_DBGCFG4		(ARRIA10_HMC_MMR_IO48_ADDR + 0x10)
#define ARRIA10_IO48_HMC_MMR_DBGCFG5		(ARRIA10_HMC_MMR_IO48_ADDR + 0x14)
#define ARRIA10_IO48_HMC_MMR_DBGCFG6		(ARRIA10_HMC_MMR_IO48_ADDR + 0x18)
#define ARRIA10_IO48_HMC_MMR_RESERVE0		(ARRIA10_HMC_MMR_IO48_ADDR + 0x1c)
#define ARRIA10_IO48_HMC_MMR_RESERVE1		(ARRIA10_HMC_MMR_IO48_ADDR + 0x20)
#define ARRIA10_IO48_HMC_MMR_RESERVE2		(ARRIA10_HMC_MMR_IO48_ADDR + 0x24)
#define ARRIA10_IO48_HMC_MMR_CTRLCFG0		(ARRIA10_HMC_MMR_IO48_ADDR + 0x28)
#define ARRIA10_IO48_HMC_MMR_CTRLCFG1		(ARRIA10_HMC_MMR_IO48_ADDR + 0x2c)
#define ARRIA10_IO48_HMC_MMR_CTRLCFG2		(ARRIA10_HMC_MMR_IO48_ADDR + 0x30)
#define ARRIA10_IO48_HMC_MMR_CTRLCFG3		(ARRIA10_HMC_MMR_IO48_ADDR + 0x34)
#define ARRIA10_IO48_HMC_MMR_CTRLCFG4		(ARRIA10_HMC_MMR_IO48_ADDR + 0x38)
#define ARRIA10_IO48_HMC_MMR_CTRLCFG5		(ARRIA10_HMC_MMR_IO48_ADDR + 0x3c)
#define ARRIA10_IO48_HMC_MMR_CTRLCFG6		(ARRIA10_HMC_MMR_IO48_ADDR + 0x40)
#define ARRIA10_IO48_HMC_MMR_CTRLCFG7		(ARRIA10_HMC_MMR_IO48_ADDR + 0x44)
#define ARRIA10_IO48_HMC_MMR_CTRLCFG8		(ARRIA10_HMC_MMR_IO48_ADDR + 0x48)
#define ARRIA10_IO48_HMC_MMR_CTRLCFG9		(ARRIA10_HMC_MMR_IO48_ADDR + 0x4c)
#define ARRIA10_IO48_HMC_MMR_DRAMTIMING0	(ARRIA10_HMC_MMR_IO48_ADDR + 0x50)
#define ARRIA10_IO48_HMC_MMR_DRAMODT0		(ARRIA10_HMC_MMR_IO48_ADDR + 0x54)
#define ARRIA10_IO48_HMC_MMR_DRAMODT1		(ARRIA10_HMC_MMR_IO48_ADDR + 0x58)
#define ARRIA10_IO48_HMC_MMR_SBCFG0		(ARRIA10_HMC_MMR_IO48_ADDR + 0x5c)
#define ARRIA10_IO48_HMC_MMR_SBCFG1		(ARRIA10_HMC_MMR_IO48_ADDR + 0x60)
#define ARRIA10_IO48_HMC_MMR_SBCFG2		(ARRIA10_HMC_MMR_IO48_ADDR + 0x64)
#define ARRIA10_IO48_HMC_MMR_SBCFG3		(ARRIA10_HMC_MMR_IO48_ADDR + 0x68)
#define ARRIA10_IO48_HMC_MMR_SBCFG4		(ARRIA10_HMC_MMR_IO48_ADDR + 0x6c)
#define ARRIA10_IO48_HMC_MMR_SBCFG5		(ARRIA10_HMC_MMR_IO48_ADDR + 0x70)
#define ARRIA10_IO48_HMC_MMR_SBCFG6		(ARRIA10_HMC_MMR_IO48_ADDR + 0x74)
#define ARRIA10_IO48_HMC_MMR_SBCFG7		(ARRIA10_HMC_MMR_IO48_ADDR + 0x78)
#define ARRIA10_IO48_HMC_MMR_CALTIMING0		(ARRIA10_HMC_MMR_IO48_ADDR + 0x7c)
#define ARRIA10_IO48_HMC_MMR_CALTIMING1		(ARRIA10_HMC_MMR_IO48_ADDR + 0x80)
#define ARRIA10_IO48_HMC_MMR_CALTIMING2		(ARRIA10_HMC_MMR_IO48_ADDR + 0x84)
#define ARRIA10_IO48_HMC_MMR_CALTIMING3		(ARRIA10_HMC_MMR_IO48_ADDR + 0x88)
#define ARRIA10_IO48_HMC_MMR_CALTIMING4		(ARRIA10_HMC_MMR_IO48_ADDR + 0x8c)
#define ARRIA10_IO48_HMC_MMR_CALTIMING5		(ARRIA10_HMC_MMR_IO48_ADDR + 0x90)
#define ARRIA10_IO48_HMC_MMR_CALTIMING6		(ARRIA10_HMC_MMR_IO48_ADDR + 0x94)
#define ARRIA10_IO48_HMC_MMR_CALTIMING7		(ARRIA10_HMC_MMR_IO48_ADDR + 0x98)
#define ARRIA10_IO48_HMC_MMR_CALTIMING8		(ARRIA10_HMC_MMR_IO48_ADDR + 0x9c)
#define ARRIA10_IO48_HMC_MMR_CALTIMING9		(ARRIA10_HMC_MMR_IO48_ADDR + 0xa0)
#define ARRIA10_IO48_HMC_MMR_CALTIMING10	(ARRIA10_HMC_MMR_IO48_ADDR + 0xa4)
#define ARRIA10_IO48_HMC_MMR_DRAMADDRW		(ARRIA10_HMC_MMR_IO48_ADDR + 0xa8)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND0		(ARRIA10_HMC_MMR_IO48_ADDR + 0xac)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND1		(ARRIA10_HMC_MMR_IO48_ADDR + 0xb0)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND2		(ARRIA10_HMC_MMR_IO48_ADDR + 0xb4)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND3		(ARRIA10_HMC_MMR_IO48_ADDR + 0xb8)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND4		(ARRIA10_HMC_MMR_IO48_ADDR + 0xbc)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND5		(ARRIA10_HMC_MMR_IO48_ADDR + 0xc0)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND6		(ARRIA10_HMC_MMR_IO48_ADDR + 0xc4)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND7		(ARRIA10_HMC_MMR_IO48_ADDR + 0xc8)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND8		(ARRIA10_HMC_MMR_IO48_ADDR + 0xcc)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND9		(ARRIA10_HMC_MMR_IO48_ADDR + 0xd0)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND10		(ARRIA10_HMC_MMR_IO48_ADDR + 0xd4)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND11		(ARRIA10_HMC_MMR_IO48_ADDR + 0xd8)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND12		(ARRIA10_HMC_MMR_IO48_ADDR + 0xdc)
#define ARRIA10_IO48_HMC_MMR_SIDEBANB13		(ARRIA10_HMC_MMR_IO48_ADDR + 0xe0)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND14		(ARRIA10_HMC_MMR_IO48_ADDR + 0xe4)
#define ARRIA10_IO48_HMC_MMR_SIDEBAND15		(ARRIA10_HMC_MMR_IO48_ADDR + 0xe8)
#define ARRIA10_IO48_HMC_MMR_DRAMSTS		(ARRIA10_HMC_MMR_IO48_ADDR + 0xec)
#define ARRIA10_IO48_HMC_MMR_DBGDONE		(ARRIA10_HMC_MMR_IO48_ADDR + 0xf0)
#define ARRIA10_IO48_HMC_MMR_DBGSIGNALS		(ARRIA10_HMC_MMR_IO48_ADDR + 0xf4)
#define ARRIA10_IO48_HMC_MMR_DBGRESET		(ARRIA10_HMC_MMR_IO48_ADDR + 0xf8)
#define ARRIA10_IO48_HMC_MMR_DBGMATCH		(ARRIA10_HMC_MMR_IO48_ADDR + 0xfc)
#define ARRIA10_IO48_HMC_MMR_COUNTER0MASK	(ARRIA10_HMC_MMR_IO48_ADDR + 0x100)
#define ARRIA10_IO48_HMC_MMR_COUNTER1MASK	(ARRIA10_HMC_MMR_IO48_ADDR + 0x104)
#define ARRIA10_IO48_HMC_MMR_COUNTER0MATCH	(ARRIA10_HMC_MMR_IO48_ADDR + 0x108)
#define ARRIA10_IO48_HMC_MMR_COUNTER1MATCH	(ARRIA10_HMC_MMR_IO48_ADDR + 0x10c)
#define ARRIA10_IO48_HMC_MMR_NIOSRESERVE0	(ARRIA10_HMC_MMR_IO48_ADDR + 0x110)
#define ARRIA10_IO48_HMC_MMR_NIOSRESERVE1	(ARRIA10_HMC_MMR_IO48_ADDR + 0x114)
#define ARRIA10_IO48_HMC_MMR_NIOSRESERVE2	(ARRIA10_HMC_MMR_IO48_ADDR + 0x118)

union dramaddrw_reg {
	struct {
		u32 cfg_col_addr_width:5;
		u32 cfg_row_addr_width:5;
		u32 cfg_bank_addr_width:4;
		u32 cfg_bank_group_addr_width:2;
		u32 cfg_cs_addr_width:3;
		u32 reserved:13;
	};
	u32 word;
};

union ctrlcfg0_reg {
	struct {
		u32 cfg_mem_type:4;
		u32 cfg_dimm_type:3;
		u32 cfg_ac_pos:2;
		u32 cfg_ctrl_burst_len:5;
		u32 reserved:18;  /* Other fields unused */
	};
	u32 word;
};

union ctrlcfg1_reg {
	struct {
		u32 cfg_dbc3_burst_len:5;
		u32 cfg_addr_order:2;
		u32 cfg_ctrl_enable_ecc:1;
		u32 reserved:24;  /* Other fields unused */
	};
	u32 word;
};

union caltiming0_reg {
	struct {
		u32 cfg_act_to_rdwr:6;
		u32 cfg_act_to_pch:6;
		u32 cfg_act_to_act:6;
		u32 cfg_act_to_act_db:6;
		u32 reserved:8;  /* Other fields unused */
	};
	u32 word;
};

union caltiming1_reg {
	struct {
		u32 cfg_rd_to_rd:6;
		u32 cfg_rd_to_rd_dc:6;
		u32 cfg_rd_to_rd_db:6;
		u32 cfg_rd_to_wr:6;
		u32 cfg_rd_to_wr_dc:6;
		u32 reserved:2;
	};
	u32 word;
};

union caltiming2_reg {
	struct {
		u32 cfg_rd_to_wr_db:6;
		u32 cfg_rd_to_pch:6;
		u32 cfg_rd_ap_to_valid:6;
		u32 cfg_wr_to_wr:6;
		u32 cfg_wr_to_wr_dc:6;
		u32 reserved:2;
	};
	u32 word;
};

union caltiming3_reg {
	struct {
		u32 cfg_wr_to_wr_db:6;
		u32 cfg_wr_to_rd:6;
		u32 cfg_wr_to_rd_dc:6;
		u32 cfg_wr_to_rd_db:6;
		u32 cfg_wr_to_pch:6;
		u32 reserved:2;
	};
	u32 word;
};

union caltiming4_reg {
	struct {
		u32 cfg_wr_ap_to_valid:6;
		u32 cfg_pch_to_valid:6;
		u32 cfg_pch_all_to_valid:6;
		u32 cfg_arf_to_valid:8;
		u32 cfg_pdn_to_valid:6;
	};
	u32 word;
};

union caltiming9_reg {
	struct {
		u32 cfg_4_act_to_act:8;
		u32 reserved:24;
	};
	u32 word;
};

#define IRQ_ECC_SERR						34
#define IRQ_ECC_DERR						32

#define ARRIA10_ECC_HMC_OCP_DDRIOCTRL_IO_SIZE			0x00000001

#define ARRIA10_ECC_HMC_OCP_INTSTAT_SERRPENA			0x00000001
#define ARRIA10_ECC_HMC_OCP_INTSTAT_DERRPENA			0x00000002
#define ARRIA10_ECC_HMC_OCP_ERRINTEN_SERRINTEN			0x00000001
#define ARRIA10_ECC_HMC_OCP_ERRINTEN_DERRINTEN			0x00000002
#define ARRIA10_ECC_HMC_OCP_INTMOD_INTONCMP			0x00010000
#define ARRIA10_ECC_HMC_OCP_INTMOD_SERR				0x00000001
#define ARRIA10_ECC_HMC_OCP_INTMOD_EXT_ADDRPARITY		0x00000100
#define ARRIA10_ECC_HMC_OCP_ECCCTL_AWB_CNT_RST			0x00010000
#define ARRIA10_ECC_HMC_OCP_ECCCTL_CNT_RST			0x00000100
#define ARRIA10_ECC_HMC_OCP_ECCCTL_ECC_EN			0x00000000
#define ARRIA10_ECC_HMC_OCP_ECCCTL2_RMW_EN			0x00000100
#define ARRIA10_ECC_HMC_OCP_ECCCTL2_AWB_EN			0x00000001
#define ARRIA10_ECC_HMC_OCP_ERRINTEN_SERR			0x00000001
#define ARRIA10_ECC_HMC_OCP_ERRINTEN_DERR			0x00000002
#define ARRIA10_ECC_HMC_OCP_ERRINTEN_HMI			0x00000004
#define ARRIA10_ECC_HMC_OCP_INTSTAT_SERR			0x00000001
#define ARRIA10_ECC_HMC_OCP_INTSTAT_DERR			0x00000002
#define ARRIA10_ECC_HMC_OCP_INTSTAT_HMI				0x00000004
#define ARRIA10_ECC_HMC_OCP_INTSTAT_ADDRMTCFLG			0x00010000
#define ARRIA10_ECC_HMC_OCP_INTSTAT_ADDRPARFLG			0x00020000
#define ARRIA10_ECC_HMC_OCP_INTSTAT_DERRBUSFLG			0x00040000

#define ARRIA10_ECC_HMC_OCP_SERRCNTREG_VALUE			8

#define ARRIA10_NOC_MPU_DDR_T_SCHED_DDRTIMING_ACTTOACT_LSB	22
#define ARRIA10_NOC_MPU_DDR_T_SCHED_DDRTIMING_RDTOMISS_LSB	0
#define ARRIA10_NOC_MPU_DDR_T_SCHED_DDRTIMING_WRTOMISS_LSB	0
#define ARRIA10_NOC_MPU_DDR_T_SCHED_DDRTIMING_BURSTLEN_LSB	2
#define ARRIA10_NOC_MPU_DDR_T_SCHED_DDRTIMING_RDTOWR_LSB	6
#define ARRIA10_NOC_MPU_DDR_T_SCHED_DDRTIMING_WRTORD_LSB	15
#define ARRIA10_NOC_MPU_DDR_T_SCHED_DDRTIMING_BWRATIO_LSB	0

#define ARRIA10_NOC_MPU_DDR_T_SCHED_DDRMOD_AUTOPRECHARGE_LSB	0
#define ARRIA10_NOC_MPU_DDR_T_SCHED_DDRMOD_BWRATIOEXTENDED_LSB	0

#define ARRIA10_NOC_MPU_DDR_T_SCHED_ACTIVATE_RRD_LSB		4
#define ARRIA10_NOC_MPU_DDR_T_SCHED_ACTIVATE_FAW_LSB		13
#define ARRIA10_NOC_MPU_DDR_T_SCHED_ACTIVATE_FAWBANK_LSB	4

#define ARRIA10_NOC_MPU_DDR_T_SCHED_DEVTODEV_BUSRDTORD_LSB	4
#define ARRIA10_NOC_MPU_DDR_T_SCHED_DEVTODEV_BUSRDTOWR_LSB	6
#define ARRIA10_NOC_MPU_DDR_T_SCHED_DEVTODEV_BUSWRTORD_LSB	6

#define ARRIA10_SDR_FW_MPU_FPGA_EN			(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x00)
#define ARRIA10_SDR_FW_MPU_FPGA_EN_SET			(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x04)
#define ARRIA10_SDR_FW_MPU_FPGA_EN_CLR			(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x08)
#define ARRIA10_SDR_FW_MPU_FPGA_MPUREGION0ADDR		(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x10)
#define ARRIA10_SDR_FW_MPU_FPGA_MPUREGION1ADDR		(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x14)
#define ARRIA10_SDR_FW_MPU_FPGA_MPUREGION2ADDR		(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x18)
#define ARRIA10_SDR_FW_MPU_FPGA_MPUREGION3ADDR		(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x1c)
#define ARRIA10_SDR_FW_MPU_FPGA_FPGA2SDRAM0REGION0ADDR	(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x20)
#define ARRIA10_SDR_FW_MPU_FPGA_FPGA2SDRAM0REGION1ADDR	(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x24)
#define ARRIA10_SDR_FW_MPU_FPGA_FPGA2SDRAM0REGION2ADDR	(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x28)
#define ARRIA10_SDR_FW_MPU_FPGA_FPGA2SDRAM0REGION3ADDR	(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x2c)
#define ARRIA10_SDR_FW_MPU_FPGA_FPGA2SDRAM1REGION0ADDR	(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x30)
#define ARRIA10_SDR_FW_MPU_FPGA_FPGA2SDRAM1REGION1ADDR	(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x34)
#define ARRIA10_SDR_FW_MPU_FPGA_FPGA2SDRAM1REGION2ADDR	(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x38)
#define ARRIA10_SDR_FW_MPU_FPGA_FPGA2SDRAM1REGION3ADDR	(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x3c)
#define ARRIA10_SDR_FW_MPU_FPGA_FPGA2SDRAM2REGION0ADDR	(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x40)
#define ARRIA10_SDR_FW_MPU_FPGA_FPGA2SDRAM2REGION1ADDR	(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x44)
#define ARRIA10_SDR_FW_MPU_FPGA_FPGA2SDRAM2REGION2ADDR	(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x48)
#define ARRIA10_SDR_FW_MPU_FPGA_FPGA2SDRAM2REGION3ADDR	(ARRIA10_SDR_FW_MPU_FPGA_ADDR + 0x4c)

#define ARRIA10_NOC_FW_DDR_MPU_MPUREG0EN		BIT(0)
#define ARRIA10_NOC_FW_DDR_MPU_MPUREG1EN		BIT(1)
#define ARRIA10_NOC_FW_DDR_MPU_MPUREG2EN		BIT(2)
#define ARRIA10_NOC_FW_DDR_MPU_MPUREG3EN		BIT(3)
#define ARRIA10_NOC_FW_DDR_MPU_F2SDR0REG0EN		BIT(4)
#define ARRIA10_NOC_FW_DDR_MPU_F2SDR0REG1EN		BIT(5)
#define ARRIA10_NOC_FW_DDR_MPU_F2SDR0REG2EN		BIT(6)
#define ARRIA10_NOC_FW_DDR_MPU_F2SDR0REG3EN		BIT(7)
#define ARRIA10_NOC_FW_DDR_MPU_F2SDR1REG0EN		BIT(8)
#define ARRIA10_NOC_FW_DDR_MPU_F2SDR1REG1EN		BIT(9)
#define ARRIA10_NOC_FW_DDR_MPU_F2SDR1REG2EN		BIT(10)
#define ARRIA10_NOC_FW_DDR_MPU_F2SDR1REG3EN		BIT(11)
#define ARRIA10_NOC_FW_DDR_MPU_F2SDR2REG0EN		BIT(12)
#define ARRIA10_NOC_FW_DDR_MPU_F2SDR2REG1EN		BIT(13)
#define ARRIA10_NOC_FW_DDR_MPU_F2SDR2REG2EN		BIT(14)
#define ARRIA10_NOC_FW_DDR_MPU_F2SDR2REG3EN		BIT(15)

#define ARRIA10_NOC_FW_DDR_L3_EN			(ARRIA10_NOC_FW_DDR_L3_DDR_SCR_ADDR + 0x00)
#define ARRIA10_NOC_FW_DDR_L3_EN_SET			(ARRIA10_NOC_FW_DDR_L3_DDR_SCR_ADDR + 0x04)
#define ARRIA10_NOC_FW_DDR_L3_EN_CLR			(ARRIA10_NOC_FW_DDR_L3_DDR_SCR_ADDR + 0x08)
#define ARRIA10_NOC_FW_DDR_L3_HPSREGION0ADDR		(ARRIA10_NOC_FW_DDR_L3_DDR_SCR_ADDR + 0x0c)
#define ARRIA10_NOC_FW_DDR_L3_HPSREGION1ADDR		(ARRIA10_NOC_FW_DDR_L3_DDR_SCR_ADDR + 0x10)
#define ARRIA10_NOC_FW_DDR_L3_HPSREGION2ADDR		(ARRIA10_NOC_FW_DDR_L3_DDR_SCR_ADDR + 0x14)
#define ARRIA10_NOC_FW_DDR_L3_HPSREGION3ADDR		(ARRIA10_NOC_FW_DDR_L3_DDR_SCR_ADDR + 0x18)
#define ARRIA10_NOC_FW_DDR_L3_HPSREGION4ADDR		(ARRIA10_NOC_FW_DDR_L3_DDR_SCR_ADDR + 0x1c)
#define ARRIA10_NOC_FW_DDR_L3_HPSREGION5ADDR		(ARRIA10_NOC_FW_DDR_L3_DDR_SCR_ADDR + 0x20)
#define ARRIA10_NOC_FW_DDR_L3_HPSREGION6ADDR		(ARRIA10_NOC_FW_DDR_L3_DDR_SCR_ADDR + 0x24)
#define ARRIA10_NOC_FW_DDR_L3_HPSREGION7ADDR		(ARRIA10_NOC_FW_DDR_L3_DDR_SCR_ADDR + 0x28)
#define ARRIA10_NOC_FW_DDR_L3_GLOBAL			(ARRIA10_NOC_FW_DDR_L3_DDR_SCR_ADDR + 0x2c)

#define ARRIA10_NOC_FW_DDR_L3_HPSREG0EN			BIT(0)
#define ARRIA10_NOC_FW_DDR_L3_HPSREG1EN			BIT(1)
#define ARRIA10_NOC_FW_DDR_L3_HPSREG2EN			BIT(2)
#define ARRIA10_NOC_FW_DDR_L3_HPSREG3EN			BIT(3)
#define ARRIA10_NOC_FW_DDR_L3_HPSREG4EN			BIT(4)
#define ARRIA10_NOC_FW_DDR_L3_HPSREG5EN			BIT(5)
#define ARRIA10_NOC_FW_DDR_L3_HPSREG6EN			BIT(6)
#define ARRIA10_NOC_FW_DDR_L3_HPSREG7EN			BIT(7)

#define ARRIA10_IO48_DRAMTIME_MEM_READ_LATENCY		0x0000003f

int arria10_ddr_calibration_sequence(void);

#endif
